
// ----------------------------------------------------------------------

void calcQV() {
  // calculate quiver offset value, approx +/- 5
  qVal = (servoVUL-servoVLL)/45;
}

// ----------------------------------------------------------------------

void centreJoyX() {
  // centre the joystick based on the current limits, LL, UL
  servoVal = servoVLL + ((servoVUL - servoVLL)/2);
  setXSlider(); drawFlag = 1;
}

// ----------------------------------------------------------------------

void centreServo() {
  // centre the servo based on the current limits, LL, UL
  centreJoyX(); servoLast = servoVal;
  sendAngle();
}

// ----------------------------------------------------------------------

void decPeriod() {
  // decrement the period value
  if (period > 10) {period--; drawFlag = 1;}
}

// ----------------------------------------------------------------------

void decXSlider() {
  // decrement slider value
  if (servoVal > servoVLL) {
    servoLast = servoVal;
    if (angleMode > 0) {
      servoVal--;
    } else {
      zF = servoVal;
      zF = 0.27 + (((zF - 1000.0) * 180.0) / 1000.0); zF--;
      servoVal = int((zF * 1000.0)/180.0) + 1000; 
      servoVal = max(servoVal,servoVLL);
    } setXSlider(); sendAngle();
  }
}

// ----------------------------------------------------------------------

void doQuiver() {
  // send quiver angles
  quiverFlag--;
  if (quiverFlag < 1) {
    quiverFlag = 5; // main timer base on draw loop timings
    if (qPhase < 1) {
      qPhase = 1;
      msgTx = "SM" + str(servoVal + qVal) + ".";
    } else {
      qPhase = 0;
      msgTx = "SM" + str(servoVal - qVal) + ".";
    }
    usbPortWrite(msgTx); drawFlag = 1;
  }
}

// ----------------------------------------------------------------------

void doSine() {
  // send sinewave angles
  float zHA = (servoVUL-servoVLL)/2.0;
  float zMP = zHA + servoVLL;
  timeCnt--;
  if (timeCnt < 1) {
    timeCnt = period;
    if (phase < 1) {phase = 1;} else {phase = 0; cycles++;}
  }
  if (phase < 1) {
    // first half-cycle
    zF = zMP + (zHA * sin(((period - timeCnt)*3.14)/period));
  } else {
    zF = zMP - (zHA * sin(((timeCnt)*3.14)/period));
  } servoVal = int(zF);
  setXSlider(); sendAngle(); drawFlag = 1;
}

// ----------------------------------------------------------------------

void doSquare() {
  // send squarewave angles
  timeCnt--;
  if (timeCnt < 1) {
    timeCnt = period;
    if (phase < 1) {
      phase = 1; servoVal = servoVUL;
    } else {
      phase = 0; servoVal = servoVLL; cycles++;
    }
    setXSlider(); sendAngle(); drawFlag = 1;
  }
}

// ----------------------------------------------------------------------

void doSwing() {
  // send cranked swing wave angles
  timeCnt--;
  if (timeCnt == period/2) {
    servoVal = servoVLL + ((servoVUL - servoVLL)/2);
    setXSlider(); sendAngle(); drawFlag = 1;
  }
  if (timeCnt < 1) {
    timeCnt = period;
    if (phase < 1) {
      phase = 1;
      servoVal = servoVUL;
    } else {
      phase = 0;
      servoVal = servoVLL;
      cycles++;
    }
    setXSlider(); sendAngle(); drawFlag = 1;
  }
}

// ----------------------------------------------------------------------

void doTriangle() {
  // send triangle waveform angles
  timeCnt--;
  if (timeCnt < 1) {
    timeCnt = period;
    if (phase < 1) {phase = 1;} else {phase = 0; cycles++;}
  }
  if (phase < 1) {
    // first half-cycle
    servoVal = (((servoVUL-servoVLL)*(period-timeCnt))/period) + servoVLL;
  } else {
    servoVal = (((servoVUL-servoVLL)*timeCnt)/period) + servoVLL;
  }
  setXSlider(); sendAngle(); drawFlag = 1;
}

// ----------------------------------------------------------------------

void drawChMsg() {
  // put text in Ch field
  if (servoPin < 0) {TR = 255;}
  drawTxtField("    ", 462, 34);
  drawTxtField(msgCh, 462, 34); TR = 0;
}

// ----------------------------------------------------------------------

void drawCOMMsg() {
  // put text in COM value field
  if (comFlag < 1) {TR = 255;}
  drawTxtField(msgCOM, 95, 237); TR = 0;
}

// ----------------------------------------------------------------------

void drawCycles() {
  // put text in Ch field
  if (ctrlMode < 1) {TR = 255;}
  drawTxtField("              ", 676, 339);
  drawTxtField(str(cycles), 676, 339); TR = 0;
}

// ----------------------------------------------------------------------

void drawFreq() {
  // put text in Freq. value field
  if (ctrlMode < 1) {TR = 255;}
  drawTxtField(str(period), 695, 305); TR = 0;
}

// ----------------------------------------------------------------------

void drawJoyX() {
  // draw the X joystick slider
  int zXw = 20; stroke(0,0,0); 
  strokeWeight(2); fill(255,255,255); 
  rect(JoyXval-zXw,159,zXw+zXw,40);
}

// ----------------------------------------------------------------------

void drawLamps() {
  // draw lamps based on flags
  fill(20,210,0); stroke(0,0,0); strokeWeight(1); // green
  if (angleMode < 1) {
    rect(649,69,9,29);
  } else {
    rect(649,109,9,29);
  }
  if (pingON > 0) {rect(745,109,9,29);}
  fill(255,50,0); // red
  switch(ctrlMode) {
    case 0:
      ellipse(116,296,21,21); 
      if ((quiverFlag > 0) && (qPhase > 0)) {fill(0,100,255); ellipse(216,296,21,21);}
      break;
    case 1:
      ellipse(317,296,21,21); break;
    case 2:
      ellipse(418,296,21,21); break;
    case 3:
      ellipse(518,296,21,21); break;
    case 4:
      ellipse(619,296,21,21); break;
  }
}

// ----------------------------------------------------------------------

void drawLLMsg() {
  // put text in LL value field
  if (angleMode < 1) {TR = 255;}
  drawTxtField("    ", 66, 172);
  if (angleMode > 0) {
    drawTxtField(str(servoVLL), 66, 172); TR = 0;
  } else {
    drawTxtField(str(int((servoVLL-servoVLL)*180)/(servoVUL-servoVLL)), 66, 172); TR = 0;
  } TR = 0;
}

// ----------------------------------------------------------------------

void drawMouseXY() {
  // draws the value of mouse x,y top left
  mX = mouseX; mY = mouseY;
  fill(200,200,200); rect(10,8,50,30);
  fill(0,0,0); text("X=" + mX, 12, 20); text("Y=" + mY, 12, 34);
}

// ----------------------------------------------------------------------

void drawRxMsg() {
  // put text in the Rx field
  drawTxtField("                                                       ", 246, 237);
  drawTxtField(msgRx, 246, 237);
}

// ----------------------------------------------------------------------

void drawServoVal() {
  // put text in Val field
  drawTxtField("         ", 561, 34);
  // normal single channel mode
  if (angleMode > 0) {
    drawTxtField(str(servoVal), 561, 34);
  } else {
    drawTxtField(str(int((servoVal-servoVLL)*180)/(servoVUL-servoVLL)), 561, 34);
  }
}

// ----------------------------------------------------------------------

void drawTxMsg() {
  // put text in Tx field
  drawTxtField("                                                      ", 540, 237);
  drawTxtField(msgTx, 540, 237);
}

// ----------------------------------------------------------------------

void drawTxtField(String zM,int zX, int zY) {
  stroke(242,242,242); fill(242,242,242); 
  rect(zX, zY, 8+textWidth(zM), 14);
  fill(TR,TG,TB); text(zM, zX+4, zY+12);
}

// ----------------------------------------------------------------------

void drawULMsg() {
  // put text in UL value field
  if (angleMode < 1) {TR = 255;}
  drawTxtField("    ", 701, 172);
  if (angleMode > 0) {
    drawTxtField(str(servoVUL), 701, 172); TR = 0;
  } else {
    drawTxtField(str(int((servoVUL-servoVLL)*180)/(servoVUL-servoVLL)), 701, 172); TR = 0;
  } TR = 0;
}

// ----------------------------------------------------------------------

void exit() {
  // program is closing so reset Arduino...
  usbPortWrite("!");
  delay(20); // allow 20ms for data to be sent
  super.exit();
}

// ----------------------------------------------------------------------

void getCOMPort() {
  // initialise serial comms if a port exists
  if (comFlag > 0) {
    // stops an existing connection if already made
    usbPort.stop();
    comFlag = 0; msgCOM = "----"; delay(100);
  }
  comListLength = Serial.list().length;
  if (comListLength > 0) {
    comPnt++; if (comPnt >= comListLength) {comPnt = 0;}
    // test available serial port
    comName = Serial.list()[comPnt];
    println(comName);
    try {
      usbPort = new Serial(this, comName, 19200);
      usbPort.bufferUntil(LF);
      comFlag = 1; msgCOM = comName;
    } catch(Exception e) {
      comFlag = 0; msgCOM = "-Error-";
    }
  } else {
    // no serial port available
    comFlag = 0; msgCOM = "-NA-";
  } refreshFlag = 1;
}

// ----------------------------------------------------------------------

void incPeriod() {
  // increment the period value
  period++; drawFlag = 1;
}

// ----------------------------------------------------------------------

void incXSlider() {
  // increment slider value
  if (servoVal < servoVUL) {
    servoLast = servoVal;
    if (angleMode > 0) {
      servoVal++;
    } else {
      zF = servoVal;
      zF = 0.27 + (((zF - 1000.0) * 180.0) / 1000.0); zF++;
      servoVal = int((zF * 1000.0)/180.0) + 1000; 
      servoVal = min(servoVal,servoVUL);
    } setXSlider(); sendAngle();
  }
}

// ----------------------------------------------------------------------

void loadScrn(int zMode) {
  // load a background image
  if (zMode == 0) {img = loadImage("Control Pad.png");}
  drawFlag = 1;
}

// ----------------------------------------------------------------------

void readXSlider() {
  // determine X-slider position and send value
  JoyXval = mX; JoyXval = max(JoyXval, JoyX0);
  JoyXval = min(JoyXval, JoyX1);
  // normal single channel mode
  servoVal = servoVLL + (((JoyXval - JoyX0) * (servoVUL - servoVLL)) / (JoyX1 - JoyX0));
  servoVal = max(servoVal, servoVLL);
  servoVal = min(servoVal, servoVUL);
  if (servoLast != servoVal) {
    servoLast = servoVal;
    sendAngle();
  } servoLast = servoVal;
}

// ----------------------------------------------------------------------

void resetFlags() {
  // set flags to match RESET condition
  angleMode = 1; // 0 = degrees, 1 = microseconds
  ctrlMode = 0; // control mode, 0 = slider, 1 = square, 2 = triangle, 3 =sine
  cycles = 0; // waveform counter
  msgCh = "---"; // channel message sent to Arduino
  mTO = 0; // mouse down timeout
  period = 60; // half period in draw loop units
  phase = 0; // current waveform phase
  qPhase = 0; // quiver phase, 0 or 1
  quiverFlag = 0; // Quiver mode 0 = OFF, 1 = ON
  qVal = 100; // applied quiver offset
  servoMin = 400; // limit constants for servo values
  servoMax = 2600; // limit constants for servo values
  servoMMD = servoMax - servoMin; // limit difference constant for servo values
  servoPin = -1; // pin number used by Arduino
  servoSwp = 0; // servo sweep flag; default = 0  OFF, 1 = ON
  servoVal = 1472; // =90' servo middle value
  servoVLL = 400; // =0' servo LL value
  servoVUL = 2600; // =180' servo UL value
  sliderDwn = 0; // =1 when mouse is clicked on slider
  timeCnt = 0; // wave count down timer
  TMC = 0; // main loop skip timer
  //
  centreJoyX();
}

// ----------------------------------------------------------------------

void sendAngle() {
  // send an angle value to the USB port depending on mode
  if (angleMode > 0) {
    msgTx = "SM" + str(servoVal) + ".";
  } else {
    msgTx = "SA" + str(int((servoVal-servoVLL)*180)/(servoVUL-servoVLL)) + ".";
  }
  usbPortWrite(msgTx); drawFlag = 1;
}

// ----------------------------------------------------------------------

void sendButton(String zS) {
  // called when a button is clicked on the scrn
  msgTx = zS; usbPortWrite(msgTx);
  drawFlag = 1;
}

// ----------------------------------------------------------------------

void sendLL() {
  // send a lower limit msg to arduino
  msgTx = "SL" + str(servoVLL) + "."; usbPortWrite(msgTx);
  drawFlag = 1;
}

// ----------------------------------------------------------------------

void sendPin() {
  // toggle selected Pin number
  int zPin = (mX-199)/50;
  if (mY > 104) {zPin = zPin + 7;}
  if (servoPin != zPin) {
    // new pin number selected
    sendLL(); sendUL();
    msgCh = str(zPin);
    sendButton("SP" + str(zPin) + ".");
    servoPin = zPin;  
  } else {
    // same pin so toggle OFF
    msgCh = "---";
    sendButton("SD.");
    servoPin = -1;  
  }
  drawFlag = 1;
}

// ----------------------------------------------------------------------

void sendRESET() {
  // reset defaults and send RESET msg to arduino
  msgTx = "!"; usbPortWrite(msgTx);
  resetFlags(); drawFlag = 1;
}

// ----------------------------------------------------------------------

void sendUL() {
  // send an upper limit msg to arduino
  msgTx = "SU" + str(servoVUL) + "."; usbPortWrite(msgTx);
  drawFlag = 1;
}

// ----------------------------------------------------------------------

void setAngleMode(int zA) {
  // called to switch between angle modes
  angleMode = zA; drawFlag = 1;
}

// ----------------------------------------------------------------------

void setLL() {
  // set lower limit from slider position
  servoVLL = servoVal;
  setXSlider(); sendLL(); calcQV();
}

// ----------------------------------------------------------------------

void setLLValDwn() {
  // reduce the slider lower limit
  if (angleMode > 0) {
    servoVLL--;
    servoVLL = max(servoMin,servoVLL);
    setXSlider(); sendLL(); calcQV();
  }
}

// ----------------------------------------------------------------------

void setLLValUp() {
  // increase the slider upper limit
  if (angleMode > 0) {
    servoVLL++;
    if (servoVLL > servoVUL) {servoVUL = servoVLL;}
    servoVLL = min(servoMax,servoVLL);
    servoVUL  = min(servoMax,servoVUL);
    setXSlider(); sendLL(); calcQV();
  }
}

// ----------------------------------------------------------------------

void setMode(int zM) {
  // set the mode to zM
  phase = 0; period = 60;
  switch(zM) {
    case 0:
      // slider mode
      break;
    case 1:
      // squarewave mode
      break;
    case 2:
      // triangle wave mode
      break;
  } ctrlMode = zM; drawFlag = 1;
}

// ----------------------------------------------------------------------

void setQuiver() {
  // toggle the quiver if in mode 0
  if (ctrlMode == 0) {
    if (quiverFlag < 1) {
      // turn quiver ON
      quiverFlag = 1; qPhase = 0; calcQV();
    } else {
      // turn quiver OFF and centre value
      quiverFlag = -1;
      msgTx = "SM" + str(servoVal) + ".";
    }
  } drawFlag = 1;
}

// ----------------------------------------------------------------------

void setQuiverOFF() {
  // turn the quiver mode OFF
  quiverFlag = 0;
  msgTx = "SM" + str(servoVal) + ".";
  usbPortWrite(msgTx); drawFlag = 1;
}

// ----------------------------------------------------------------------

void setUL() {
  // set upper limit from slider position
  servoVUL = servoVal;
  setXSlider(); sendUL(); calcQV();
}

// ----------------------------------------------------------------------

void setULValDwn() {
  // reduce the slider upper limit
  if (angleMode > 0) {
    servoVUL--;
    if (servoVUL < servoVLL) {servoVLL = servoVUL;}
    servoVLL = max(servoVLL, servoMin);
    servoVUL = max(servoVUL, servoMin);
    setXSlider(); sendUL(); calcQV();
  }
}

// ----------------------------------------------------------------------

void setULValUp() {
  // increase the slider upper limit
  if (angleMode > 0) {
      servoVUL++;
      servoVUL = min(servoMax,servoVUL);
      setXSlider(); sendUL(); calcQV();
  }
}

// ----------------------------------------------------------------------

void setXSlider() {
  // set the X-slider position based on servoVal
  int zVal = servoVal;
  servoVal = min(servoVal, servoVUL);
  servoVal = max(servoVal, servoVLL);
  if (servoVUL > servoVLL) {
    JoyXval = 170 + ((servoVal - servoVLL) * (630 - 170))/(servoVUL - servoVLL);
  }
  JoyXval = max(170, JoyXval); // prevent it going too low
  JoyXval = min(630, JoyXval); // prevent it going too high
  if (zVal != servoVal) {
    servoLast = servoVal;
    sendAngle();
  }
  drawFlag = 1;
}

//-------------------------------------------------------------------------

void toggleMouseON() {
  // toggle mouse ON/OFF flag
  if (mON > 0) {
    mON = 0;
  } else {
    mON = 1;
  } drawFlag = 1;
}

// ----------------------------------------------------------------------

void togglePing() {
  // toggle ping flag ON/OFF
  if (pingON > 0) {
    pingON = 0;
  } else {
    pingON = 1;
  }
  drawFlag = 1;
}

// ----------------------------------------------------------------------

void usbPortWrite(String zmsg) {
  // called to send text over the serial port
  if (comFlag > 0) {usbPort.write(zmsg);}
}
// ----------------------------------------------------------------------
